-- Anonymous Devices Table
-- For auto-sync without login

CREATE TABLE IF NOT EXISTS anonymous_devices (
    id INT PRIMARY KEY AUTO_INCREMENT,
    device_id VARCHAR(255) NOT NULL UNIQUE,
    device_name VARCHAR(100) DEFAULT 'Unknown',
    platform ENUM('android', 'ios', 'web') DEFAULT 'android',
    user_id INT NOT NULL,
    recovery_code VARCHAR(10) NOT NULL,
    sync_data JSON DEFAULT NULL,
    last_sync TIMESTAMP NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    INDEX idx_device (device_id),
    INDEX idx_recovery (recovery_code),
    INDEX idx_user (user_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
